#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// PBR with TextureMod01.fsh  by  zxxuan1001  
//https://www.shadertoy.com/view/tlXSzn
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define AA_SIZE 2
#define PI 3.1415926
#define EPSILON 0.0001
#define IBL 1
const int MAX_STEPS = 120;
const float MAX_DISTANCE = 60.0;
const vec3 FOG_COLOR = vec3(0.9, 0.9, 0.7);
const float ROUGHNESS = 0.5;
const float METALLIC = 1.0;
const vec3 LIGHT_COLOR = vec3(300.0, 300.0, 250.0);

float plane(vec3 p) 
{
    return p.y;
}

float sdSphere(vec3 p, float r)
{
    return length(p) - r;
}

vec2 unionSDF(vec2 d1, vec2 d2) 
{
    return d1.x < d2.x? d1 : d2;
}

vec3 doTranslate(vec3 p, vec3 offset) 
{
    return p - offset;
}

vec3 rotX(vec3 p, float d) 
{
    mat4 rotM= mat4(1.0, 0.0, 0.0, 0.0, 
                    0.0, cos(d), -sin(d), 0.0, 
                    0.0, sin(d), cos(d), 0.0, 
                    0.0, 0.0, 0.0, 1.0);
    return vec3(rotM * vec4(p, 1.0));
}

vec3 rotY(vec3 p, float d) 
{
    mat4 rotM= mat4(cos(d), 0.0, sin(d), 0.0, 
                    0.0, 1.0, 0.0, 0.0,
                    -sin(d), 0.0, cos(d), 0.0, 
                    0.0, 0.0, 0.0, 1.0);
    return vec3(rotM * vec4(p, 1.0));
}


vec3 rotZ(vec3 p, float d) {
    mat4 rotM= mat4(cos(d), -sin(d), 0.0, 0.0, 
                    sin(d), cos(d), 0.0, 0.0, 
                    0.0, 0.0, 1.0, 0.0, 
                    0.0, 0.0, 0.0, 1.0);
    return vec3(rotM * vec4(p, 1.0));
}

vec2 sceneSDF(vec3 p) 
{
    vec2 result = vec2(plane(p), -1.0);
    
    vec3 p1 = doTranslate(p,vec3(0.0, 3.5 , 0.0));
    vec2 result1 = vec2(sdSphere( p1, 3.0));  
    result1.x *= 0.4;
    result = unionSDF(result, result1);
    return result;
}

vec2 marching(vec3 ro, vec3 rd) 
{
    float tmax = MAX_DISTANCE;
    float t = 0.01;
    vec2 result = vec2(-1.0);
    
    for (int i = 0; i < MAX_STEPS; i++)
    {
        vec3 p = ro + rd * t;
        vec2 res = sceneSDF(p);
        if (res.x < EPSILON)
        {
            return result;
        }
        else if (t > tmax)
        {
            result.y = -1.0;
            result.x = tmax;
            break;
        }
        t += res.x;
        result.x = t;
        result.y = res.y;
    }
    
    return result;
}

float calcShadow(in vec3 ro, in vec3 rd) {
    float mint = 0.1;
    float t = mint;
    float res = 1.0;
    float k = 4.0;
    for (int i = 0; i < 40; i++)
    {
        float h = sceneSDF(ro + rd * t).x;
        
		res = min( res, k * h / t );
        t += clamp( h, 0.02, 0.20 );
     
        if ( h < EPSILON ) 
        {
            res = min(res, 0.0);
            break;
        } 
    }
    return clamp( res, 0.0, 1.0 );
}

float calcAO( in vec3 pos, in vec3 nor )
{
	float occ = 0.0;
    float sca = 1.0;
    float h = 0.001;
    for( float i = 0.0; i < 5.0; i++ )
    {
        float d = sceneSDF( pos + h * nor ).x;
        occ += ( h - d ) * sca;
        sca *= 0.85;
        h += 0.45 * i / 5.0;
    }
    return clamp( 1.0 - occ, 0.0, 1.0 );    
}

const vec2 OFFSET = vec2(EPSILON, 0.0);
vec3 getNormal(vec3 p) {
    return normalize(vec3(
        sceneSDF(p + OFFSET.xyy).x - sceneSDF(p - OFFSET.xyy).x,
        sceneSDF(p + OFFSET.yxy).x - sceneSDF(p - OFFSET.yxy).x,
        sceneSDF(p + OFFSET.yyx).x - sceneSDF(p - OFFSET.yyx).x
    ));
}

vec3 ground(vec2 uv) 
{
    vec3 col = vec3(0.5, 0.4, 0.3);
    return  col; 
}

//Distribution/concentration
float D_GGX(float dotnh, float roughness) 
{
    float a = roughness * roughness;
    float a2 = a * a;
    float dotnh2 = dotnh * dotnh;
    float denom =  max(dotnh2 * (a2 - 1.0) + 1.0, EPSILON);
    return a2 /(PI * denom * denom);
}

float G_SGGX(float dotnv, float roughness)
{
    //for direct lighting
    float r = roughness + 1.0;
      
#ifdef IBL
    float k = roughness * roughness / 2.0;
#else
    float k = (r * r) / 8.0; 
#endif
    
    return dotnv / (dotnv * (1.0 - k) + k);
}
//Geometry/shadowing masking
float G_Smith(float dotnv, float dotnl, float roughness)
{
    
    float ggx1 = G_SGGX(dotnv, roughness);
    float ggx2 = G_SGGX(dotnl, roughness);
    return ggx1 * ggx2;
}
//Fresnel/reflectivity
vec3 Fs(float dothv, vec3 f0)
{
    return max(f0 + (1.0 - f0) * pow((1.0 - dothv), 5.0), 0.0);
}

vec3 PBL(vec3 ro, vec3 p, float objId) 
{
    vec3 Lo = vec3(0.0);
    vec3 lights[2];
    vec3 lightColor = LIGHT_COLOR;
    lights[0] = vec3(6.0, 8.0, -3.0);
    lights[1] = vec3(-6.0, 8.0, -3.0);
    
    
    vec3 viewDir = ro - p;
    vec3 V = normalize(viewDir);
    vec3 N = getNormal(p);
    
    vec3 albedo = vec3(0.6, 0.6, 0.3); //surface color
    float metallic = METALLIC;
    float roughness = ROUGHNESS;
    float u = atan(N.x, N.z) / PI + 0.5;
	float v = N.y * 0.5 + 0.5;
    vec3 tex = texture2D(texture0, vec2(u,v)).rgb;
    float greyScale = dot(tex, vec3(0.299, 0.587, 0.114));
    metallic = 1.0-tex.r; //(tex.r + tex.g + tex.b) / 3.0;
    roughness = 1.0 - greyScale * 2.0;
    
    if (objId == -1.0) 
    {//floor     
        albedo = ground(p.xz); 
    } else
    {
        albedo = pow(tex, vec3(2.2));
    }
    
    for (int i = 0; i < 2; i++)
    {
        vec3 lightPos = lights[i];
        
        vec3 lightDir = lightPos - p;
        float dist = length(lightDir);
 
        vec3 L = normalize(lightDir);
        vec3 H = normalize(V + L);
        
        float sd = calcShadow(p, normalize(lightPos));
        float att = 1.0 / ( dist * dist );
        vec3 radiance = lightColor * att * sd; 

        float dothv = max(dot(H, V), 0.0);
        float dotnh = max(dot(N, H), 0.0);
        float dotnv = max(dot(N, V), 0.0);
        float dotnl = max(dot(N, L), 0.0);
		
        //Cook-Torrance specular BRDF term
        vec3 f0 = vec3(0.04);
        f0 = mix(f0, albedo, metallic);  
        vec3 F = Fs(dothv, f0);
        
        float D = D_GGX(dotnh, roughness);
        float GS = G_Smith(dotnv, dotnl, roughness);
        
        vec3 nom = D * GS * F;
        float denom = 4.0 * dotnv * dotnl;
        vec3 Fct = nom / max(denom, EPSILON); //avoid zero denom

        vec3 Ks = F; //specular
        vec3 Kd = 1.0 - Ks; //diffuse 
        Kd *= 1.0 - metallic;
        
        //Lambert
        vec3 Fl = albedo/PI; 
        
        //final results
        Lo += (Kd * Fl + Fct) * radiance * dotnl; 
    }
    
    float ao = calcAO(p, N);
    vec3 ambient = vec3(0.05) * albedo * ao;
    return ambient + Lo ;
}

 

mat3 getCamera( in vec3 ro, in vec3 ta)
{
	vec3 cw = normalize(ta-ro);
	vec3 cp = vec3(0.0, 1.0, 0.0);
	vec3 cu = normalize( cross(cw,cp) );
	vec3 cv =          ( cross(cu,cw) );
    return mat3( cu, cv, cw );
}

vec3 fog(in vec3 pixColor, in float dist) 
{
    return mix(pixColor, vec3(0.8), 1.0 - exp(-dist * 0.003));
}

vec3 background(vec2 uv) 
{
    vec3 col = vec3(0.0);
    return col;
}


vec3 render(in vec2 fragCoord) 
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = fragCoord/iResolution.xy;
    uv -= 0.5; // translate to the center of the screen
    uv.x *= iResolution.x/iResolution.y; // restore aspect ratio
    
    vec3 col = vec3(0.0);
    vec2 mouse = vec2(0.1) + iMouse.xy / iResolution.xy ;
    mouse -= 0.5;
    float t = iTime * 0.1;
    vec3 ro = vec3(8.0 * cos(mouse.x * 2.0 * PI + t),  4.0 + mouse.y * 3.0, 8.0 * sin(mouse.x * 2.0 * PI + t));
    vec3 ta = vec3(0.0, 4.0, 0.0);
    mat3 cam = getCamera(ro, ta);
    vec3 rd = normalize(cam * vec3(uv, 1.2));
    
    vec2 h = marching(ro, rd);
    vec3 p = ro + rd * h.x;
    if (h.x < MAX_DISTANCE) 
    {
        if (h.y == 0.0) 
        {
            col = vec3(0.0);
        } 
        
        col += PBL(ro, p, h.y);
    } else 
    {
        //background
        col = background(uv); 
    }
    
    col = fog(col, h.x); 
    return col;
}




//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    float count = 0.0;  
    vec3 col = vec3(0.0);
#if AA_SIZE>1 
   
    for (float aay = 0.0; aay < float(AA_SIZE); aay++) 
    {
        for (float aax = 0.0; aax < float(AA_SIZE); aax++) 
        {
            col += render(fragCoord + vec2(aax, aay)/float(AA_SIZE));
            count++;
        }
    }
    col /= count;
#else
    col = render( fragCoord );
#endif
    
 	col = col / (col + vec3(1.0));
	col = pow(col, vec3(1.0/2.2)); 
    fragColor = vec4(col, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

